#!/bin/sh
# script for checking and enabling CRONTAB and WEBINTERFACE on Enigma1

TMPDIR="/tmp/CROND-ENABLE-DISABLE"
LOGDIR="/var/ch_list_log"
LOG_FILE="$LOGDIR/enable-disable_crond.txt"
CH_LIST_SCRIPT_DIR="/var/script/ch_list_scripts"
MAX_ALLOWED_SIZE_OF_LOG_FILE=20; #20KB
#------
ENIGMA_CONF_FILE="/var/tuxbox/config/enigma/config"
CROND_SCRIPT_FILE="/var/script/crond_script.sh"
TYPE_TO_CROND_MES_NEW_CH_LIST_E1="0 21 * * * /var/script/ch_list_scripts/message_new_ch_list_E1.sh"
date=`date -R`

chk_dir() {

if [ ! -e $TMPDIR ];
	then
		echo -e "There wasn't a directory with name $TMPDIR...\nNow it is created..."
		mkdir -p $TMPDIR;								 #Force to create directory
fi
if [ ! -e $LOGDIR ];
	then
		echo -e "There wasn't a directory with name $LOGDIR...\nNow it is created..."
		mkdir -p $LOGDIR;								 #Force to create directory
fi
echo >> $LOG_FILE
if [ ! -e $CH_LIST_SCRIPT_DIR ];
	then
		echo -e "There wasn't a directory with name $CH_LIST_SCRIPT_DIR...\nNow it is created..."
		mkdir -p $CH_LIST_SCRIPT_DIR;								 #Force to create directory
fi
}

check_is_crond_dir_installed(){
	if [ ! -e /var/etc/cron/crontabs/ ] 2> /dev/null
	then
		echo "I can not find '/etc/cron/crontabs/' dir. Now creating..."
		echo "$date I can not find '/etc/cron/crontabs/' dir. Now creating..." >> $LOG_FILE
		mkdir -p /var/etc/cron/crontabs/
		echo "$TYPE_TO_CROND_MES_NEW_CH_LIST_E1" >> /var/etc/cron/crontabs/root
		chmod 755 /var/etc/cron/crontabs/root
		echo "Done!"
		echo "$date Done!" >> $LOG_FILE
	else
		echo -e "Crond directory exist\nDo nothing!"
		echo -e "Crond directory exist\nDo nothing!" >> $LOG_FILE
		if [ ! -e /var/etc/cron/crontabs/root ] 2> /dev/null
		then
			echo "I can not find '/etc/cron/crontabs/root' file. Now creating..."
			echo "$date I can not find '/etc/cron/crontabs/root' file. Now creating..." >> $LOG_FILE
			echo "$TYPE_TO_CROND_MES_NEW_CH_LIST_E1" >> /var/etc/cron/crontabs/root
			chmod 755 /var/etc/cron/crontabs/root
			echo "Done!"
			echo "$date Done!" >> $LOG_FILE
		else
			echo -e "Crond file exist\nDo nothing!"
			echo -e "Crond file exist\nDo nothing!" >> $LOG_FILE
		fi
	fi
}

start_crond_service(){
	check_is_crond_dir_installed
	if [ ! -e /var/script/crond_script.sh ] 2> /dev/null
	then	
		make_crond_script
		chmod 755 /var/script/crond_script.sh
	else
		echo "Script is there"
	fi
	
	if grep -qs CROND_ON=1 $CROND_SCRIPT_FILE ; then
		echo -e "Crond Service was started\nDo nothing..."
	else
		LINE_No_1=`awk '/CROND_ON=/ {print FNR}' $CROND_SCRIPT_FILE`; #grep only or awk for found line number
		sed -i ''$LINE_No_1's/.$/1/' $CROND_SCRIPT_FILE  #change to /1/ only last caracter from line number
		echo -e "Crond Service was stoped.\nNow it is STARTED..."
		/sbin/crond -c /var/etc/cron/crontabs
	fi
	
	#-----------
	#ukoliko je broj pronadjenih linija u crondu ovih: * * * * * /var/script/ch_list_scripts/message_new_ch_list_E1.sh  veci od 0 tada brisi ih sve
	if [ $(grep -c "/var/script/ch_list_scripts/message_new_ch_list_E1.sh" /var/etc/cron/crontabs/root) -ge 0 ];then  #count,broj,broji ponavljanja i ispise ga
		echo -e "Broj linija je: $(grep -c "/var/script/ch_list_scripts/message_new_ch_list_E1.sh" /var/etc/cron/crontabs/root) i on je veci od 0"
		sed -i '/\/var\/script\/ch_list_scripts\/message_new_ch_list_E1.sh/d' /var/etc/cron/crontabs/root;   #delete,brisi sve linije koje sadrze text /var/script/ch_list_scripts/message_new_plugin_update_E1.sh  kose crte su escape caracters
		sed -i -e '$a\' /var/etc/cron/crontabs/root;	#Dodaj "new line" na kraj file-a
		echo "$TYPE_TO_CROND_MES_NEW_CH_LIST_E1" >> /var/etc/cron/crontabs/root
#	else #je veci ili jednak od 0
#		echo -e "Broj linija je: $(grep -c "/var/script/ch_list_scripts/message_new_ch_list_E1.sh" /var/etc/cron/crontabs/root) i on je veci ili jednak od 0"
	fi
	
	sed -i '/^$/d' /var/etc/cron/crontabs/root;   #Brisi sve linije koje su prazne
	#-----------
	#Proverava da li je zadnja linija "new line" tj prazan red, ako nije dodaje na kraj, ali ako vec postoji nece dodati
	if [ -s /var/etc/cron/crontabs/root -a "$(tail -c 1 /var/etc/cron/crontabs/root)" = "" ]; then
		echo "Has newline";
	else
		echo "No newline";
		sed -i -e '$a\' /var/etc/cron/crontabs/root;	#Dodaj "new line" na kraj file-a
	fi
}

stop_crond_service(){
	check_is_crond_dir_installed
	if [ ! -e /var/script/crond_script.sh ] 2> /dev/null
	then	
		make_crond_script
		chmod 755 /var/script/crond_script.sh
	else
		echo "Script is there"
	fi
	
	if grep -qs CROND_ON=0 $CROND_SCRIPT_FILE ; then
		echo -e "Crond Service was stoped\nDo nothing..."
	else
		LINE_No_1=`awk '/CROND_ON=/ {print FNR}' $CROND_SCRIPT_FILE`; #grep only or awk for found line number
		sed -i ''$LINE_No_1's/.$/0/' $CROND_SCRIPT_FILE  #change to /0/ only last caracter from line number
		echo -e "Crond Service was started.\nNow it is STOPED..."
		killall -9 crond
	fi
		#-----------
	#ukoliko je broj pronadjenih linija u crondu ovih: * * * * * /var/script/ch_list_scripts/message_new_ch_list_E1.sh  veci od 0 tada brisi ih sve
	if [ $(grep -c "/var/script/ch_list_scripts/message_new_ch_list_E1.sh" /var/etc/cron/crontabs/root) -ge 0 ];then  #count,broj,broji ponavljanja i ispise ga
		echo -e "Broj linija je: $(grep -c "/var/script/ch_list_scripts/message_new_ch_list_E1.sh" /var/etc/cron/crontabs/root) i on je veci od 0"
		sed -i '/\/var\/script\/ch_list_scripts\/message_new_ch_list_E1.sh/d' /var/etc/cron/crontabs/root;   #delete,brisi sve linije koje sadrze text /var/script/ch_list_scripts/message_new_plugin_update_E1.sh  kose crte su escape caracters
		sed -i -e '$a\' /var/etc/cron/crontabs/root;	#Dodaj "new line" na kraj file-a
		echo "$TYPE_TO_CROND_MES_NEW_CH_LIST_E1" >> /var/etc/cron/crontabs/root
#	else #je veci ili jednak od 0
#		echo -e "Broj linija je: $(grep -c "/var/script/ch_list_scripts/message_new_ch_list_E1.sh" /var/etc/cron/crontabs/root) i on je veci ili jednak od 0"
	fi
	
	sed -i '/^$/d' /var/etc/cron/crontabs/root;   #Brisi sve linije koje su prazne
	#-----------
	#Proverava da li je zadnja linija "new line" tj prazan red, ako nije dodaje na kraj, ali ako vec postoji nece dodati
	if [ -s /var/etc/cron/crontabs/root -a "$(tail -c 1 /var/etc/cron/crontabs/root)" = "" ]; then
		echo "Has newline";
	else
		echo "No newline";
		sed -i -e '$a\' /var/etc/cron/crontabs/root;	#Dodaj "new line" na kraj file-a
	fi
}
	

check_enigma_conf_file(){
	if grep -qs lockmessage=00000000 $ENIGMA_CONF_FILE ; then
		echo -e "lockmessage is 00000000 (Turned on)\nI do nothing.."
	else
		echo -e "lockmessage is 00000001 (Turned off)\nI'm changing it!"
		
		LINE_No_1=`awk '/lockmessage/ {print FNR}' $ENIGMA_CONF_FILE`; #grep only or awk for found line number
		sed -i ''$LINE_No_1's/.$/0/' $ENIGMA_CONF_FILE  #change to /0/ only last caracter from line number 
	fi
}

check_enigma_conf_file_web_login(){ 
	if grep -qs lockWebIf=00000000 $ENIGMA_CONF_FILE ; then
		echo -e "lockWebIf is 00000000 (Turned on)\nI do nothing.."
	else
		echo -e "lockWebIf is 00000001 (Turned off)\nI'm changing it!"
		LINE_No_1=`awk '/lockWebIf/ {print FNR}' $ENIGMA_CONF_FILE`; #grep only or awk for found line number
		sed -i ''$LINE_No_1's/.$/0/' $ENIGMA_CONF_FILE  #change to /0/ only last caracter from line number 
	fi
}


#++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Proverava da li je log file veci od x MB ++++++++++++++++++++++++++++++++++++++++++++++++++++++
chk_is_log_lile_biger_than_x_KB(){
echo >> $LOG_FILE
SIZE_OF_LOG_FILE=`(du ${LOG_FILE} | sed 's/\([0-9]*\)\(.*\)/\1/')`; # du -h uzima size of file, a ostatak kida ime file i izbacuje samo prvi broj (94434b=9)
if [ "$SIZE_OF_LOG_FILE" -ge "$MAX_ALLOWED_SIZE_OF_LOG_FILE" ]; then
	echo -e "Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!"
	echo -e "$date Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!" >> $LOG_FILE
	#zip -j9 $LogDir/$Zip_Name $LogFile
	#mv -f $LogDir/$Zip_Name.zip $LogDir_Zipped/$Zip_Name--[$short_date].zip
	rm -fr $LOG_FILE
else 
	echo -e "Log File is smaller than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!"
	echo -e "$date Log File is smaller than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!" >> $LOG_FILE
fi
}
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 


rmove() {
	rm -fr $TMPDIR
}

start_draw() {
echo -e "\n************************************************** -- ENABLE --  *********************************************************************" >> $LOG_FILE
}

stop_draw() {
echo -e "\n**************************************************************************************************************************************\n\n" >> $LOG_FILE
}

#################################################################  MAIN PROGRAM  ######################################################################
chk_dir
start_draw
if [ $# -eq 1 ]; then
	if [ $1 = "-enable" ]; then
		start_crond_service
	else
		if [ $1 = "-disable" ]; then
			stop_crond_service
		fi
	fi
else
	echo -e "Function was called without parameters"
	echo -e "Please call this script like:\n\nenable-disable-crond_E1.sh -enable\n\nor\n\nenable-disable-crond_E1.sh -disable\n"
	echo -e "Function was called without parameters" >> $LOG_FILE
	echo -e "Please call this script like:\nenable-disable-crond_E1.sh -enable\nor\nenable-disable-crond_E1.sh -disable" >> $LOG_FILE
	stop_draw
	rmove
	exit
fi
check_enigma_conf_file
check_enigma_conf_file_web_login
stop_draw
reboot
rmove

######################################################################################################################################################
make_crond_script(){
echo -e '##!/bin/sh

CROND_ON=0
NAME=crond
ARGS="-c /var/etc/cron/crontabs"

set -e

if [ -f /usr/sbin/crond ]
then
DAEMON=/usr/sbin/crond
else
DAEMON=/sbin/crond
fi

test -f $DAEMON || exit 0

case "$1" in
    start)
if [ $CROND_ON -ne 0 ]; then
echo -n "starting $NAME... "
start-stop-daemon -S -b -n $NAME -a $DAEMON -- $ARGS
echo "done."
fi
;;
    stop)
echo -n "stopping $NAME... "
start-stop-daemon -K -n $NAME
echo "done."
;;
    restart)
echo -n "restarting $NAME... "
$0 stop
$0 start
echo "done."
;;
    reload)
echo -n "reloading $NAME... "
killall -HUP $(basename ${DAEMON})
echo "done."
;;
    *)
echo "Usage: $0 {start|stop|restart|reload}"
exit 1
;;
esac

exit 0' > /var/script/crond_script.sh
}



exit;

