#!/bin/sh
# script to download latest channels lists

#---- Definate variable -----
DELAY=10
DM_SETTINGS_FILE="/var/tuxbox/config/enigma/config"
MAX_ALLOWED_SIZE_OF_LOG_FILE=25; #25KB
#----------------------------
chk_dir() {

if [ -e /tmp/$BQ ];
	then
		rm -fr /tmp/$BQ
		#echo -e "There was a directory with name /tmp/$BQ\nNow it is deleted..."
#	else
		#echo -e "OK..There wasn't a directory with name $GTS\b /tmp/$BQ$BQ...\n$WTS\rNow it is created..."
fi
mkdir -p /tmp/$BQ
if [ ! -e $LOGDIR ];
	then
#		echo -e "There wasn't a directory with name $LOGDIR...\nNow it is created..."
		mkdir -p $LOGDIR								 #Force to create directory
fi
rm -fr $REMOTE_VERSION
rm -fr $CHECK_FILE
echo >> $LOG_FILE
} 

checkhost() {
echo "Please Wait..Connecting to Server $FAKE_URL_FOR_USERS_1"
wget http://$URL_CH_LIST -O $CHECK_FILE > /dev/null 2>&1
svr=`cat $CHECK_FILE`
for i in $svr; 
do
if [ $i = "Unable" ]
	then
	dead=1
	echo "I found UNABLE"
elif [ $i = "can't" ]	
	then
	echo "I found CAN'T"
	dead=1
	else
	    dummyval=999
	fi
done
rm -rf /var/bin/index.html
}

download_ch_list () {
echo "Downloading Latest Channel List"
echo "$date Downloading Latest Channel List" >> $LOG_FILE
cd /tmp
mkdir -p $BQ
cd $BQ
wget http://$URL_CH_LIST/$BOUQUETE_TAR_NAME 2>> $LOG_FILE
echo "$date Successfully downloaded $BOUQUETE_TAR_NAME" >> $LOG_FILE
echo "Completed..."
}

copy_ch_list_E1 () {
echo "$date Downloaded $BOUQUETE_TAR_NAME File From Host $URL_CH_LIST" >> $LOG_FILE
chmod 755 /tmp/$BQ/$BOUQUETE_TAR_NAME
echo "Extracting Latest Channel List Enigma 1"
echo "$date Extracting Latest Channel List Enigma 1" >> $LOG_FILE
tar -xzvf $BOUQUETE_TAR_NAME > /dev/null
echo "Copying Latest Channel List Enigma 1"
echo "$date Copying Latest Channel List Enigma 1" >> $LOG_FILE
rm -rf /var/etc/satellites.xml
cd /var/tuxbox/config/enigma/
rm -rf *.tv
rm -rf *.epl
rm -rf *.radio
rm -rf *bak
rm -rf bouquets
rm -rf services
rm -rf userbouquet*
rm -rf services.locked
mv /tmp/$BQ/var/etc/* /var/etc
mv /tmp/$BQ/var/ch_list_log/* /var/ch_list_log
mv /tmp/$BQ/var/tuxbox/config/enigma/* /var/tuxbox/config/enigma
chmod 755 /var/etc/satellites.xml
rm -rf /tmp/$BQ
#rm -rf /var/tuxbox/config/enigma/$BOUQUETE_TAR_NAME
echo "$CHOSE" > /var/tuxbox/config/enigma/zlist.tv
echo "Completed Copying Latest Channel List Enigma 1"
echo "$date Completed Copying Latest Channel List Enigma 1" >> $LOG_FILE
}

detectbox () {
echo "Detecting Dreambox Type"
echo "$date Detecting Dreambox Type" >> $LOG_FILE
if grep -qs DM500 /proc/bus/dreambox ; then
	box=DM500
	etype=1
elif grep -qs DM7020 /proc/bus/dreambox ; then
	box=DM7020
	etype=1
elif grep -qs DM600PVR /proc/bus/dreambox ; then
	box=DM600PVR
	etype=1
elif grep -qs DM500PLUS /proc/bus/dreambox ; then
	box=DM500plus
	etype=1
elif grep -qs 'dm8000' /proc/stb/info/model ; then
	box=DM8000HD
	etype=2
elif grep -qs 'dm800sev2' /proc/stb/info/model ; then
	box=DM800sev2
	etype=2
elif grep -qs 'dm800' /proc/stb/info/model ; then
	box=DM800HD
	etype=2
elif grep -qs 'dm500hd' /proc/stb/info/model ; then
	box=DM500HD/VU+
	etype=2
#For Amiko SDH-8900 ALien with E2
elif grep -qs 'spark' /proc/stb/info/model ; then
	box=Amiko
	etype=2
else
	box=UNDEFINED
	etype=0
fi

echo "Detected $box"
echo "$date $box and Enigma $etype Detected" >> $LOG_FILE
if [ $etype -eq 1 ]; then
  echo "Enigma1 detected..."
  echo "$date Enigma1 detected..." >> $LOG_FILE
elif [ $etype -eq 2 ]; then   
  echo "Enigma2 detected..."
  echo "$date Enigma2 NOT supported..." >> $LOG_FILE
  remove_tmp
  exit;
elif [ $etype -eq 0 ]; then
  echo "*** ERROR Box Not Identified ***"
  echo "$date *** ERROR Unable to Identify Dreambox Version ***"  >> $LOG_FILE
  echo "Process Complete With Errors"
  echo "$date Process Complete With Errors" >> $LOG_FILE
  remove_tmp
  exit
fi
}

remove_tmp(){
	rm -rf $REMOTE_VERSION
	rm -rf $CHECK_FILE
	rm -rf /tmp/$BQ
	echo "Temp dir cleared"
}

getverfile () {
cd /tmp
wget "http://$URL_CH_LIST_UPDATE" > /dev/null 2>&1
chmod 666 $REMOTE_VERSION
}

date_msg(){
#Sva 3 fajla od kanal lista se u istom momentu prace tj kopiram na server, tako da je svejedno koji cu izabrati za prikaz datuma 
	WEBIF_DATE_MSG=`cat $CHECK_FILE|grep "tar.gz"|head -n 1|sed 's/<[^>]\+>/ /g'|awk -F" " '{print $2"--"$3}'`
}

determinate_webif_port(){
hex_to_dec () {
	PortDec=`echo $((0x$PortHex))`
}

ConfigPATH="/var/tuxbox/config/enigma/config"
if [ ! -f "$ConfigPATH" ]; then
	ConfigPATH="/etc/enigma/config"
	if [ ! -f "$ConfigPATH" ]; then PortDec="80"; fi
fi
PortHex=`grep 'webifport=' "$ConfigPATH"| sed -e 's/.*webifport=//'`
if [ ! $PortHex ]; then
	PortDec="80"
else
	hex_to_dec
fi

DM_WEB_ADDRESS_PORT="127.0.0.1:$PortDec"
echo -e "Webif port is: $PortDec"
}

reload_list(){
	echo "Now reloading bouquetes..Please wait.."
	echo -e "\n\n$date Now reloading bouquetes..Please wait.." >>  $LOG_FILE
	wget -q -O /dev/null http://$DM_WEB_ADDRESS_PORT/cgi-bin/reloadSettings && wget -q -O /dev/null http://$DM_WEB_ADDRESS_PORT/cgi-bin/reloadUserBouquets;
}


postcheck() {
if [ ! -e /var/tuxbox/config/enigma/userbo*.tv ] 2> /dev/null
then
	echo "It was error! Files from /etc/enigma2/ missed\nNow trying again!"
	echo "$date It was error! Files from /etc/enigma2/ missed\nNow trying again!" >>  $LOG_FILE
	chk_dir
	detectbox
	checkhost
	download_ch_list
	if [ $etype -eq 1 ]; then
	  copy_ch_list_E1
	elif [ $etype -eq 2 ]; then
	  echo "Enigma2 detected..."
    echo "$date Enigma2 NOT supported..." >> $LOG_FILE
    remove_tmp
    exit;
	fi
	remove_tmp
fi
}

start_draw() {
echo -e "\n**************************************************************************************************************************************" >> $LOG_FILE
}

stop_draw() {
echo -e "\n**************************************************************************************************************************************\n\n" >> $LOG_FILE
}

main_function(){
chk_dir
start_draw
echo "Starting Updating the Channel List"
echo -e "\n\n$date Starting Update" >>  $LOG_FILE
detectbox
checkhost
determinate_webif_port
date_msg

if [ $dead = 0 ]
then
	echo "Connected to Server"
	echo "$date Successfully Connected to HOST" >>  $LOG_FILE
  INSTALED_BQ_TYPE=`cat /var/tuxbox/config/enigma/zlist.tv 2> /dev/null`
  if [ $INSTALED_BQ_TYPE = $CHOSE ] 2> /dev/null; then
  	if [ ! -f "$VER_FILE" ]; then
	  	echo "Version File Missing!!!"
	  	echo "$date Version File Missing!!!" >>  $LOG_FILE
	  	if [ $etype -eq 1 ]; then
	  		download_ch_list
	  	  copy_ch_list_E1
	  	elif [ $etype -eq 2 ]; then
			  echo "Enigma2 detected..."
      	echo "$date Enigma2 NOT supported..." >> $LOG_FILE
      	remove_tmp
      	exit;
	  	fi 
	  	getverfile
    	mv $REMOTE_VERSION $VER_FILE
    	chmod 666 $VER_FILE
    	echo "Version File Missed..Now it is: v$VER_FILE"
    	echo "$date Version File Missed..Now it is: v$VER_FILE" >>  $LOG_FILE
    	reload_list
			stop_draw
	  	remove_tmp
	  	exit;
	  fi
	else
		########################################################
		#Ovaj deo koda se nikada nece desiti jer je zasticen e1_message_new_ch_list.sh scriptom da ukoliko u zlist.tv se ne poklapa ime da ni ne pokrece ceo ovaj script
		if [ $etype -eq 1 ]; then
		  echo "Enigma1 detected..."
      echo "$date Enigma1 detected..." >> $LOG_FILE
      download_ch_list
      copy_ch_list_E1
		elif [ $etype -eq 2 ]; then   
      echo "Enigma2 detected..."
      echo "$date Enigma2 NOT supported..." >> $LOG_FILE
      remove_tmp
      exit;
    fi
	 	getverfile
   	mv $REMOTE_VERSION $VER_FILE
   	chmod 666 $VER_FILE
   	echo "Version File Missing"
   	echo "$date Version File Missing" >>  $LOG_FILE
   	reload_list
   	stop_draw
	 	remove_tmp
	 	exit;
	fi
	########################################################
  getverfile
  localv=`cat $VER_FILE`
  remotev=`cat $REMOTE_VERSION`
  if [ ! -s $VER_FILE ];then
    echo "$VER_FILE is empty."
    echo "$date VER_FILE is empty." >>  $LOG_FILE
    localv=0; #Zato sto je file prazan, inicijalizujem ga sa verzijom "0"
  fi

  if [ $remotev -gt $localv ]; then
    if [ $etype -eq 1 ]; then
   	  download_ch_list
			copy_ch_list_E1
		else
			if [ $etype -eq 2 ]; then
				echo "Enigma2 detected..."
      	echo "$date Enigma2 NOT supported..." >> $LOG_FILE
      	remove_tmp
      	exit;
			fi
		fi 
  
    mv -f $REMOTE_VERSION $VER_FILE
		chmod 666 $VER_FILE
		
		echo "REMOTE version was HIGHER than LOCAL version ($remotev > $localv)"
   	echo "$date REMOTE version was HIGHER than LOCAL version ($remotev > $localv)" >>  $LOG_FILE
		
		reload_list
		stop_draw
		remove_tmp
	else
  	echo "No Refresh Required" >>  $LOG_FILE
    echo "$date Process Complete" >>  $LOG_FILE
    stop_draw
	  remove_tmp
	  exit;
	fi
else
  echo -e "*********************************"
  echo "*** Error Connecting to Server ***"
  echo -e "*********************************"
  echo "$date *** Error Connecting To Server $FAKE_URL_FOR_USERS_1 ***" >>  $LOG_FILE
  echo "$date Process Complete With Errors" >>  $LOG_FILE
  stop_draw
  remove_tmp
fi
}

#++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Proverava da li je log file veci od x MB ++++++++++++++++++++++++++++++++++++++++++++++++++++++
chk_is_log_lile_biger_than_x_KB(){
echo >> $LOG_FILE
SIZE_OF_LOG_FILE=`(du ${LOG_FILE} | sed 's/\([0-9]*\)\(.*\)/\1/')`; # du -h uzima size of file, a ostatak kida ime file i izbacuje samo prvi broj (94434b=9)
if [ "$SIZE_OF_LOG_FILE" -ge "$MAX_ALLOWED_SIZE_OF_LOG_FILE" ]; then
	echo -e "Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!"
	echo -e "$date Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!" >> $LOG_FILE
	#zip -j9 $LogDir/$Zip_Name $LogFile
	#mv -f $LogDir/$Zip_Name.zip $LogDir_Zipped/$Zip_Name--[$short_date].zip
	rm -fr $LOG_FILE
else 
	echo -e "Log File is smaller than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!"
	echo -e "$date Log File is smaller than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!" >> $LOG_FILE
fi
}
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 




#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ MAIN PROGRAM ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#---Definate Variables---
if [ $# -eq 1 ];
then
  if [ $1 = "-UPC+DIGI_[No_Romanian]" ];
  then
  CHOSE="UPC+DIGI_[No_Romanian]"
	echo "UPC+DIGI_[No_Romanian]"
	dead=0
	dummyval=1
	box="UNDEFINED"
	j=1
	LOGDIR="/var/ch_list_log"
	VER_FILE="$LOGDIR/$CHOSE-ver.txt"
	CHECK_FILE="/tmp/check.txt"
	REMOTE_VERSION="/tmp/remotever.txt"
	LOG_FILE="$LOGDIR/channel_list_update_log.txt"
	BQ="bouquete_folder"
	FAKE_URL_FOR_USERS_1="--Server 1--"
	etype=0
	BOUQUETE_TAR_NAME="$CHOSE.tar.gz"
	URL_CH_LIST="blokieasy.hopto.me/Files_for_recivers/Dreambox/E1"
	URL_CH_LIST_UPDATE="$URL_CH_LIST/remotever.txt"
	date=`date -R`
		chk_is_log_lile_biger_than_x_KB
  	main_function
  	postcheck
  else
  	if [ $1 = "-UPC+DIGI" ];
  	then
  		echo "UPC+DIGI"
 	  	CHOSE="UPC+DIGI"
			dead=0
			dummyval=1
			box="UNDEFINED"
			j=1
			LOGDIR="/var/ch_list_log"
			VER_FILE="$LOGDIR/$CHOSE-ver.txt"
			CHECK_FILE="/tmp/check.txt"
			REMOTE_VERSION="/tmp/remotever.txt"
			LOG_FILE="$LOGDIR/channel_list_update_log.txt"
			BQ="bouquete_folder"
			FAKE_URL_FOR_USERS_1="--Server 1--"
			etype=0
			BOUQUETE_TAR_NAME="$CHOSE.tar.gz"
			URL_CH_LIST="blokieasy.hopto.me/Files_for_recivers/Dreambox/E1"
			URL_CH_LIST_UPDATE="$URL_CH_LIST/remotever.txt"
			date=`date -R`
			chk_is_log_lile_biger_than_x_KB
 	  	main_function
 	  	postcheck
  	else
  	if [ $1 = "-45E-30W_[FULL]" ];
  	then
  		echo "45E-30W_[FULL]"
 	  	CHOSE="45E-30W_[FULL]"
			dead=0
			dummyval=1
			box="UNDEFINED"
			j=1
			LOGDIR="/var/ch_list_log"
			VER_FILE="$LOGDIR/$CHOSE-ver.txt"
			CHECK_FILE="/tmp/check.txt"
			REMOTE_VERSION="/tmp/remotever.txt"
			LOG_FILE="$LOGDIR/channel_list_update_log.txt"
			BQ="bouquete_folder"
			FAKE_URL_FOR_USERS_1="--Server 1--"
			etype=0
			BOUQUETE_TAR_NAME="$CHOSE.tar.gz"
			URL_CH_LIST="blokieasy.hopto.me/Files_for_recivers/Dreambox/E1"
			URL_CH_LIST_UPDATE="$URL_CH_LIST/remotever.txt"
			date=`date -R`
			chk_is_log_lile_biger_than_x_KB
 	  	main_function
 	  	postcheck
  	fi
  fi
fi
else 
	echo "Function was called without parameters"
	#skup_svih_fja
fi 
exit
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++