#!/bin/sh
# script to notify cleints about new channels lists on Enigma1

#---- Definate variable -----
DELAY=10
dead=0
dummyval=1
MAX_ALLOWED_SIZE_OF_LOG_FILE=25; #25KB
box="UNDEFINED"
TMP_DIR="/tmp/MESSAGE_ASK_FOR_NEW_LIST"
LOGDIR="/var/ch_list_log"
CH_LIST_SCRIPT_DIR="/var/script/ch_list_scripts"
CHECK_FILE="$TMP_DIR/check.txt"
DM_SETTINGS_FILE="/var/tuxbox/config/enigma/config"
REMOTE_VERSION="$TMP_DIR/remotever.txt"
TYPE_OF_LIST="/var/tuxbox/config/enigma/zlist.tv"
LOG_FILE="$LOGDIR/message_notify_ch_list_log.txt"
FAKE_URL_FOR_USERS_1="--Server 1--"
NO_TYPE_OF_CH_LIST_FILE=0; #Znaci da postoji info o instaliranoj listi
etype=0
date=`date -R`
#----------------------------
chk_dir() {

if [ -e $TMP_DIR ];
	then
		rm -fr $TMP_DIR
		#echo -e "There was a directory with name $TMP_DIR\nNow it is deleted..."
#	else
		#echo -e "OK..There wasn't a directory with name $TMP_DIR...\nNow it is created..."
fi
mkdir -p $TMP_DIR
if [ ! -e $LOGDIR ];
	then
#		echo -e "There wasn't a directory with name $LOGDIR...\nNow it is created..."
		mkdir -p $LOGDIR								 #Force to create directory
fi
rm -fr $REMOTE_VERSION
rm -fr $CHECK_FILE
echo >> $LOG_FILE
if [ ! -e $CH_LIST_SCRIPT_DIR ];
	then
		echo -e "There wasn't a directory with name $CH_LIST_SCRIPT_DIR...\nNow it is created..."
		mkdir -p $CH_LIST_SCRIPT_DIR;								 #Force to create directory
fi
}

checkhost() {
echo "Please Wait..Connecting to Server $FAKE_URL_FOR_USERS_1"
wget http://$URL_CH_LIST -O $CHECK_FILE > /dev/null 2>&1
svr=`cat $CHECK_FILE`
for i in $svr; 
do
if [ $i = "Unable" ]
	then
	dead=1
	echo "I found UNABLE"
elif [ $i = "can't" ]	
	then
	echo "I found CAN'T"
	dead=1
	else
	    dummyval=999
	fi
done
rm -rf /var/bin/index.html
}

detectbox () {
echo "Detecting Dreambox Type"
echo "$date Detecting Dreambox Type" >> $LOG_FILE
if grep -qs DM500 /proc/bus/dreambox ; then
	box=DM500
	etype=1
elif grep -qs DM7020 /proc/bus/dreambox ; then
	box=DM7020
	etype=1
elif grep -qs DM600PVR /proc/bus/dreambox ; then
	box=DM600PVR
	etype=1
elif grep -qs DM500PLUS /proc/bus/dreambox ; then
	box=DM500plus
	etype=1
elif grep -qs 'dm8000' /proc/stb/info/model ; then
	box=DM8000HD
	etype=2
elif grep -qs 'dm800' /proc/stb/info/model ; then
	box=DM800HD
	etype=2
elif grep -qs 'dm500hd' /proc/stb/info/model ; then
	box=DM500HD/VU+
	etype=2
#For Amiko SDH-8900 ALien with E2
elif grep -qs 'spark' /proc/stb/info/model ; then
	box=Amiko
	etype=2
else
	box=UNDEFINED
	etype=0
fi

echo "Detected $box"
echo "$date $box and Enigma $etype Detected" >> $LOG_FILE
if [ $etype -eq 1 ]; then
     echo "Enigma1 detected..."
     echo "$date Enigma1 detected..." >> $LOG_FILE
elif [ $etype -eq 2 ]; then   
     echo "Enigma2 detected..."
     echo "$date Enigma2 NOT supported..." >> $LOG_FILE
     remove_tmp
     exit;
elif [ $etype -eq 0 ]; then
   echo "*** ERROR Box Not Identified ***"
   echo "*** ERROR Unable to Identify Dreambox Version ***"  >> $LOG_FILE
   echo "Process Complete With Errors"
   echo "$date Process Complete With Errors" >> $LOG_FILE
   remove_tmp
   exit
fi
}

detectdm () {
echo "Detecting Dreambox Type"
echo "$date Detecting Dreambox Type" >> $LOG_FILE
if [ -f "/proc/bus/dreambox" ]; then
 echo "Enigma 1 Image Found"
 box=`cat /proc/bus/dreambox | grep -i ^type`
 etype=1
 #PLUGIN_UPDATE_NAME="e1.$TEMPDIR.tar.gz"
elif [ -f "/proc/stb/info/model" ]; then
  echo "Enigma 2 Image Found"
  echo "$date Enigma 2 Image Found" >> $LOG_FILE
  box=`cat /proc/stb/info/model | grep -i ^type`
  etype=2
else 
  echo "This is not a Dreambox"
  echo "$date This is not a Dreambox" >> $LOG_FILE
  exit
fi
}

remove_tmp(){
	rm -rf $TMP_DIR
echo "Temp dir cleared"
}
#***********************************************
type_of_used_list() {
	if [ -f $TYPE_OF_LIST ] 2> /dev/null
	then
		INSTALED_BQ_TYPE=`cat /var/tuxbox/config/enigma/zlist.tv 2> /dev/null`
		if [ "$INSTALED_BQ_TYPE" = "45E-30W_[FULL]" ];then
			START_UPDATE_CH_LIST_INSTALL="/var/script/ch_list_scripts/e1_45E-30W_[FULL].sh"
		else
			if [ "$INSTALED_BQ_TYPE" = "UPC+DIGI" ];then
				START_UPDATE_CH_LIST_INSTALL="/var/script/ch_list_scripts/e1_UPC+DIGI.sh"
			else
				if [ "$INSTALED_BQ_TYPE" = "UPC+DIGI_[No_Romanian]" ];then
					START_UPDATE_CH_LIST_INSTALL="/var/script/ch_list_scripts/e1_UPC+DIGI_[No_Romanian].sh"
				else
					NO_TYPE_OF_CH_LIST_FILE=1
				fi
			fi
		fi
			
		URL_CH_LIST="blokieasy.hopto.me/Files_for_recivers/Dreambox/E1/"
		URL_CH_LIST_REMOTE="$URL_CH_LIST/remotever.txt"
		VER_FILE="$LOGDIR/$INSTALED_BQ_TYPE-ver.txt"
	else
		#Ne postoji fajl sa informacijom koju listu koristi korisnik
		NO_TYPE_OF_CH_LIST_FILE=1
	fi
}
#***********************************************

date_msg(){
#Sva 3 fajla od kanal lista se u istom momentu prace tj kopiram na server, tako da je svejedno koji cu izabrati za prikaz datuma 
	WEBIF_DATE_MSG=`cat $CHECK_FILE|grep "tar.gz"|head -n 1|sed 's/<[^>]\+>/ /g'|awk -F" " '{print $2"--"$3}'`
}

getverfile () {
cd $TMP_DIR
wget "http://$URL_CH_LIST_REMOTE";# > /dev/null 2>&1
chmod 666 $REMOTE_VERSION
cd /
}

determinate_webif_port(){
hex_to_dec () {
	PortDec=`echo $((0x$PortHex))`
}

ConfigPATH="/var/tuxbox/config/enigma/config"
if [ ! -f "$ConfigPATH" ]; then
	ConfigPATH="/etc/enigma/config"
	if [ ! -f "$ConfigPATH" ]; then PortDec="80"; fi
fi
PortHex=`grep 'webifport=' "$ConfigPATH"| sed -e 's/.*webifport=//'`
if [ ! $PortHex ]; then
	PortDec="80"
else
	hex_to_dec
fi

DM_WEB_ADDRESS_PORT="127.0.0.1:$PortDec"
echo -e "Webif port is: $PortDec"
}

#***********************************************
message_notify() {	
#
#[Tuesday, January 27, 2015 7:38 AM] Cica Telenor: letbelptetshez inditsa jra a BOX-ot
#[Tuesday, January 27, 2015 7:39 AM] Cica Telenor: Ha segtsgre van szksge hvja kv. szmot+065....
#[Tuesday, January 27, 2015 7:40 AM] Cica Telenor: A+folyamat+tobb+mint+3+percig+tarthat..
if grep -qs language=hu_HU $DM_SETTINGS_FILE; then
	#Hunagry OSD  This+can+take+more+than+3+min!%0A
			
	if [ "$NO_TYPE_OF_CH_LIST_FILE" -eq "0" ];then
		echo -e "I Found: $INSTALED_BQ_TYPE type of channel list!"
		echo -e "$date I Found: $INSTALED_BQ_TYPE type of channel list!" >> $LOG_FILE
		if [ $(cat $TMP_DIR/error_webif_login.txt) = 0 ]; then
			#Nema problema..webif login je dozvoljen stoga moze da se reloaduje lista ne treba rst dreamboxa
			wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=++++++++++++Ha+segitseg+kell+hivd:+065/530-58-39&body=Uj+lista+elerheto!%0AA+$INSTALED_BQ_TYPE+lista+most+telepitve+van.%0AA+folyamat+tobb+mint+3+percig+tarthat..%0AMellozd+az+uzenetet+EXIT+gombal.%0ALista+utoljara+frissitve:++$WEBIF_DATE_MSG&icon=1&timeout=0"
		else
			#Posto webif login nije dozvoljen (izgleda manuelno neko promenio) - sada script enable-ovao, potreban rst za reload, mada ce se reload izvrsiti ali bez efekta
			wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++++++++Ha+segitseg+kell+hivd:+065/530-58-39&body=Uj+lista+elerheto!%0AA+$INSTALED_BQ_TYPE+lista+most+telepitve+van!%0AINDITSA+UJRA+A+BOX-ot+ELETBE+LEPTETESEHEZ!%0AMellozd+az+uzenetet+EXIT+gombal.%0ALista+utoljara+frissitve:++$WEBIF_DATE_MSG&icon=2&timeout=0"
		fi	

		$START_UPDATE_CH_LIST_INSTALL
		sleep 3;
		wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++Ha+segitseg+kell+hivd:+065/530-58-39&body=Uj+lista+telepitve!%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%A0%0A&icon=1&timeout=0"
	else
		echo -e "I can not found any type of channel list!\nInstalling default"
		echo -e "$date I can not found any type of channel list!\nInstalling default" >> $LOG_FILE
		wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++++Ha+segitseg+kell+hivd:+065/530-58-39&body=Uj+lista+elerheto!%0ATelepitem+a:+45E-30W_[FULL]+alapertelmezett+listat!%0AA+folyamat+tobb+mint+3+percig+tarthat..%0AMellozd+az+uzenetet+EXIT+gombal.%0ALista+utoljara+frissitve:++$WEBIF_DATE_MSG%0A&icon=1&timeout=0"
		
		echo -e "Pokrece se default installing list"
		#installing default list
		$CH_LIST_SCRIPT_DIR/e1_45E-30W_[FULL].sh
		wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++Ha+segitseg+kell+hivd:+065/530-58-39&body=Uj+lista+telepitve!%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%A0%0A&icon=1&timeout=0"
	fi
else
	if grep -qs language=hr_HR $DM_SETTINGS_FILE; then
		#Cro OSD
		
		if [ "$NO_TYPE_OF_CH_LIST_FILE" -eq "0" ];then
			echo -e "I Found: $INSTALED_BQ_TYPE type of channel list!"
			echo -e "$date I Found: $INSTALED_BQ_TYPE type of channel list!" >> $LOG_FILE
			if [ $(cat $TMP_DIR/error_webif_login.txt) = 0 ]; then
				#Nema problema..webif login je dozvoljen stoga moze da se reloaduje lista ne treba rst dreamboxa
				wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=++++++++++++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+kanala+je+dostupna!%0ALista:+$INSTALED_BQ_TYPE+se+azurira.%0AOvaj+proces+moze+da+potraje+duze+od+3min!%0APoruku+ukloniti+sa+EXIT.%0APoslednje+azuriranje:++$WEBIF_DATE_MSG&icon=1&timeout=0"
			else
				#Posto webif login nije dozvoljen (izgleda manuelno neko promenio) - sada script enable-ovao, potreban rst za reload, mada ce se reload izvrsiti ali bez efekta
				wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=++++++++++++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+kanala+je+dostupna!%0ALista:+$INSTALED_BQ_TYPE+se+azurira.%0AZA+PROMENE+POKRENUTI+DREAMBOX+PONOVO!!%0APoruku+ukloniti+sa+EXIT.%0APoslednje+azuriranje:++$WEBIF_DATE_MSG&icon=2&timeout=0"
			fi	

			$START_UPDATE_CH_LIST_INSTALL
			sleep 3;
			wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+je+sada+instalirana!%A0%0A&icon=1&timeout=0"
		else
			echo -e "I can not found any type of channel list!\nInstalling default"
			echo -e "$date I can not found any type of channel list!\nInstalling default" >> $LOG_FILE
			wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=++++++++++++++++++Za+pomoc+zvati+065/530-58-39&body=Nova+lista+kanala+je+dostupna!%0AInstaliram:+45E-30W_[FULL]+podrazumevanu+listu!%0AOvaj+proces+moze+da+potraje+duze+od+3min!%0APoruku+ukloniti+sa+EXIT.%0APoslednje+azuriranje:++$WEBIF_DATE_MSG%0A&icon=1&timeout=0"
		
			echo -e "Pokrece se default installing list"
			#installing default list
			$CH_LIST_SCRIPT_DIR/e1_45E-30W_[FULL].sh
			wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+je+sada+instalirana!%A0%0A&icon=1&timeout=0"
		fi
	else
		#Srb OSD
			
		if grep -qs language=sr_SR $DM_SETTINGS_FILE; then
			if [ "$NO_TYPE_OF_CH_LIST_FILE" -eq "0" ];then
				echo -e "I Found: $INSTALED_BQ_TYPE type of channel list!"
				echo -e "$date I Found: $INSTALED_BQ_TYPE type of channel list!" >> $LOG_FILE
				if [ $(cat $TMP_DIR/error_webif_login.txt) = 0 ]; then
					#Nema problema..webif login je dozvoljen stoga moze da se reloaduje lista ne treba rst dreamboxa
					wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=++++++++++++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+kanala+je+dostupna!%0ALista:+$INSTALED_BQ_TYPE+se+azurira.%0AOvaj+proces+moze+da+potraje+duze+od+3min!%0APoruku+ukloniti+sa+EXIT.%0APoslednje+azuriranje:++$WEBIF_DATE_MSG&icon=1&timeout=0"
				else
					#Posto webif login nije dozvoljen (izgleda manuelno neko promenio) - sada script enable-ovao, potreban rst za reload, mada ce se reload izvrsiti ali bez efekta
					wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+kanala+je+dostupna!%0ALista:+$INSTALED_BQ_TYPE+se+azurira.%0AZA+PROMENE+POKRENUTI+DREAMBOX+PONOVO!!%0APoruku+ukloniti+sa+EXIT.%0APoslednje+azuriranje:++$WEBIF_DATE_MSG&icon=2&timeout=0"
				fi	
		
				$START_UPDATE_CH_LIST_INSTALL
				sleep 3;
				wget -q -O /dev/null "http://127.0.0.1/cgi-bin/xmessage?caption=+++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+je+sada+instalirana!%A0%0A&icon=1&timeout=0"
			else
				echo -e "I can not found any type of channel list!\nInstalling default"
				echo -e "$date I can not found any type of channel list!\nInstalling default" >> $LOG_FILE
				wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=++++++++++++++++++Za+pomoc+zvati+065/530-58-39&body=Nova+lista+kanala+je+dostupna!%0AInstaliram:+45E-30W_[FULL]+podrazumevanu+listu!%0AOvaj+proces+moze+da+potraje+duze+od+3min!%0APoruku+ukloniti+sa+EXIT.%0APoslednje+azuriranje:++$WEBIF_DATE_MSG%0A&icon=1&timeout=0"
			
				echo -e "Pokrece se default installing list"
				#installing default list
				$CH_LIST_SCRIPT_DIR/e1_45E-30W_[FULL].sh
				wget -q -O /dev/null "http://127.0.0.1/cgi-bin/xmessage?caption=+++++++Za+pomoc+zvati:+065/530-58-39&body=Nova+lista+je+sada+instalirana!%A0%0A&icon=1&timeout=0"
			fi
		else
			#English OSD
			if [ "$NO_TYPE_OF_CH_LIST_FILE" -eq "0" ];then
				echo -e "I Found: $INSTALED_BQ_TYPE type of channel list!"
				echo -e "$date I Found: $INSTALED_BQ_TYPE type of channel list!" >> $LOG_FILE
				if [ $(cat $TMP_DIR/error_webif_login.txt) = 0 ]; then
					#Nema problema..webif login je dozvoljen stoga moze da se reloaduje lista ne treba rst dreamboxa
					wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++++If+you+need+help+call:+065/530-58-39&body=You+have+a+new+list!%0AChannel+list+$INSTALED_BQ_TYPE+is+now+installed!%0AThis+can+take+more+than+3+min!%0ARemove+this+message+with+EXIT.%0ALast+channel+list+was+created:++$WEBIF_DATE_MSG&icon=1&timeout=0"
				else
					#Posto webif login nije dozvoljen (izgleda manuelno neko promenio) - sada script enable-ovao, potreban rst za reload, mada ce se reload izvrsiti ali bez efekta	
					wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++++If+you+need+help+call:+065/530-58-39&body=You+have+a+new+list!%0AChannel+list+$INSTALED_BQ_TYPE+is+now+installed!%0APLEASE+RESTART+YOUR+BOX+TO+TAKE+EFFECT!!!%0ARemove+this+message+with+EXIT.%0ALast+channel+list+was+created:++$WEBIF_DATE_MSG&icon=2&timeout=0"
				fi
#				Hide Message: /cgi-bin/message oder /control/message
				$START_UPDATE_CH_LIST_INSTALL
				sleep 3;
				wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++If+you+need+help+call:+065/530-58-39&body=New+channel+list+is+installed!%A0%0A&icon=1&timeout=0"
			else
				echo -e "I can not found any type of channel list!\nInstalling default"
				echo -e "$date I can not found any type of channel list!\nInstalling default" >> $LOG_FILE
				wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++++++++If+you+need+help+call:+065/530-58-39&body=New+channel+list+aviable!%0AInstalling:+45E-30W_[FULL]+default+list!%0AThis+can+take+more+than+3+min!%0ARemove+this+message+with+EXIT.%0ALast+channel+list+was+created:++$WEBIF_DATE_MSG%0A&icon=1&timeout=0"
				echo -e "Pokrece se default installing list"
				#installing default list
				$CH_LIST_SCRIPT_DIR/e1_45E-30W_[FULL].sh
				wget -q -O /dev/null "http://$DM_WEB_ADDRESS_PORT/cgi-bin/xmessage?caption=+++If+you+need+help+call:+065/530-58-39&body=New+channel+list+is+installed!%A0%0A&icon=1&timeout=0"
			fi
		fi
	fi
fi
}
#***********************************************
start_draw() {
echo -e "\n**************************************************************************************************************************************" >> $LOG_FILE
}

stop_draw() {
echo -e "\n**************************************************************************************************************************************\n\n" >> $LOG_FILE
}

check_enigma_conf_file_web_message(){	
#Ako opcija webmessage nije dozvoljena tada kada crond proveriti novu ver, ali nece ispisati poruku (jer je zabranjeno) ali ce setovati flag u configu.
	if grep -qs lockmessage=00000000 $DM_SETTINGS_FILE ; then
		echo -e "lockmessage is 00000000 (Turned on)\nI do nothing.."
	else
		echo -e "lockmessage is 00000001 (Turned off)\nI'm changing it!"
		
		LINE_No_1=`awk '/lockmessage/ {print FNR}' $DM_SETTINGS_FILE`; #grep only or awk for found line number
		sed -i ''$LINE_No_1's/.$/0/' $DM_SETTINGS_FILE  #change to /0/ only last caracter from line number 
	fi
}

check_enigma_conf_file_web_login(){ 
	if grep -qs lockWebIf=00000000 $DM_SETTINGS_FILE ; then
		echo -e "lockWebIf is 00000000 (Turned on)\nI do nothing.."
		web_login_is_locked=0
	else
		echo -e "lockWebIf is 00000001 (Turned off)\nI'm changing it!"
		
		LINE_No_1=`awk '/lockWebIf/ {print FNR}' $DM_SETTINGS_FILE`; #grep only or awk for found line number
		sed -i ''$LINE_No_1's/.$/0/' $DM_SETTINGS_FILE  #change to /0/ only last caracter from line number 
		web_login_is_locked=1 #promenljiva koja govori da nije moguce reload liste i bouqueta vec mora da se uradi rst (Slucaj ako je korisnik manuelno cekirao za http web auth)
	fi
}

is_it_really_conf_file_web_login_enabled(){
if [ $web_login_is_locked = 0 ]; then  # Web login je omogucen, ali moram da proverim da li je zaista a to ide sa sledecim redom. 
	wget -O $TMP_DIR/result.txt http://$DM_WEB_ADDRESS_PORT/cgi-bin/currentTransponderServices 2>$TMP_DIR/webif_login_error.txt;					#sluzi da bi definisao da li zaista otvoren webif bez pass
	if grep -qs Unauthorized $TMP_DIR/webif_login_error.txt; then
		echo -e "Can not reload bouquete...It is now set to ENABLE!\nEnigma must to be restart!"
		echo -e "$date Can not reload bouquete...It is now set to ENABLE!\nEnigma must to be restart!" >>  $LOG_FILE
		echo "1" > $TMP_DIR/error_webif_login.txt
	else
		echo "Webif login was enabled before.."
		echo -e "\n$date Webif login was enabled before.." >>  $LOG_FILE
		echo "0" > $TMP_DIR/error_webif_login.txt
	fi
else
	echo -e "Can not reload bouquete...It is manualy changed from settings\nEnigma must to be restart!"
	echo -e "$date Can not reload bouquete...It is manualy changed from settings\nEnigma must to be restart!" >>  $LOG_FILE
	echo "1" > $TMP_DIR/error_webif_login.txt
fi
}

#++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Proverava da li je log file veci od x MB ++++++++++++++++++++++++++++++++++++++++++++++++++++++
chk_is_log_lile_biger_than_x_KB(){
echo >> $LOG_FILE
SIZE_OF_LOG_FILE=`(du ${LOG_FILE} | sed 's/\([0-9]*\)\(.*\)/\1/')`; # du -h uzima size of file, a ostatak kida ime file i izbacuje samo prvi broj (94434b=9)
if [ "$SIZE_OF_LOG_FILE" -ge "$MAX_ALLOWED_SIZE_OF_LOG_FILE" ]; then
	echo -e "Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!"
	echo -e "$date Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!" >> $LOG_FILE
	#zip -j9 $LogDir/$Zip_Name $LogFile
	#mv -f $LogDir/$Zip_Name.zip $LogDir_Zipped/$Zip_Name--[$short_date].zip
	rm -fr $LOG_FILE
else 
	echo -e "Log File is smaller than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!"
	echo -e "$date Log File is bigger than $MAX_ALLOWED_SIZE_OF_LOG_FILE KB!!" >> $LOG_FILE
fi
}
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 

main_function(){
chk_dir
echo "Starting ..."
start_draw
echo -e "$date Starting ..." >> $LOG_FILE
determinate_webif_port;		#Mora ovde jer f-ja "is_it_really_conf_file_web_login_enabled" koristi promenljivu: $DM_WEB_ADDRESS_PORT
check_enigma_conf_file_web_message
check_enigma_conf_file_web_login
is_it_really_conf_file_web_login_enabled;			#Ovo ce generisati file:$TMP_DIR/error_webif_login.txt u kojem cu u f-ji type_of_used_list priokazati poruku u zavisnosti od rezultata

type_of_used_list; #Mora prvo ova f-ja jer ona sadrzi ime koristene liste, a to se koristi da bi se definisao link!
detectbox
checkhost
chk_is_log_lile_biger_than_x_KB

if [ $dead = 0 ]
then
	if [ -f "$VER_FILE" ]; then
		getverfile; #Check version on remote side of resrver
		date_msg
		
		localv=`cat $VER_FILE`
		remotev=`cat $REMOTE_VERSION`
		
  	if [ ! -s $VER_FILE ];then
    	echo "$VER_FILE is empty"
    	echo "$date $VER_FILE is empty" >> $LOG_FILE
    	localv=0; #Zato sto je file prazan, inicijalizujem ga sa verzijom "0"
    fi
	  
	  if [ $remotev -gt $localv ]; then
	    if [ $etype -eq 1 ]; then
				echo "New Version of Channel List Found..Updating"
	  		echo "$date New Version of Channel List Found..Updating" >> $LOG_FILE
				message_notify
			else
				if [ $etype -eq 2 ]; then
					echo "Enigma2 detected..."
    		  echo "$date Enigma2 NOT supported..." >> $LOG_FILE
     		fi
			fi
			stop_draw
			remove_tmp
			exit
	  else
	  	echo "No Refresh Required"
	   	echo "No Refresh Required" >> $LOG_FILE
	   	echo "Process Complete"
	    echo "$date Process Complete" >> $LOG_FILE
	    stop_draw
		  remove_tmp
		  exit;
		fi
	else
		echo -e "No info about version file found...\nDo nothing!"
	  echo -e "$date No info about version file found...\nDo nothing!" >> $LOG_FILE
	  stop_draw
	fi
else
  echo -e "*********************************"
  echo "*** Error Connecting to Server ***"
  echo -e "*********************************"
  echo "$date *** Error Connecting To Server $FAKE_URL_FOR_USERS_1 ***" >> $LOG_FILE
  echo "$date Process Complete With Errors" >> $LOG_FILE
  stop_draw
  remove_tmp
fi
}


#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ MAIN PROGRAM ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
main_function
exit
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


#how to seral log dm500
Over putty seral, speed 115200, the keep backspace until you can type.
Type this:
Linux/PPC load: console= root=/dev/mtdblock5 rootfstype=squashfs ro console=ttyS0,115200




